#include "commonheaders.h"
#include "cls-menu.h"
#include "initialization.h"
#include "editor.h"
    
void Initial_Load(void) {
    if(debug) logputs("Initial Loading Sequence:\n\n");
    
    // Load the datafile conataining interface images
    char edit_string[355];
    strcpy( edit_string, install_path );
    strcat( edit_string, "Data\\Editor.dat" );
    
    printf( "DATAFILE: %s", edit_string );
    
    Editor = load_datafile( edit_string );
    abort_NULL(Editor, "DTFL&ED&0");
    	
    if(debug) logputs("\t\"Editor.dat\" opened, loading images...");
    
    // Primary mouse sprite
	mouse_spr = get_datafile_bmp(Editor[MOUSE].dat);
	abort_NULL(mouse_spr, "MSE&1");
	
	// Copy mouse sprite
	mouse_grb = get_datafile_bmp(Editor[MOUSE2].dat);
	//mouse_grb = (BITMAP*)Editor[MOUSE2].dat;
	abort_NULL(mouse_grb, "MSE&2");
	
	// Delete button image
	Delete = get_datafile_bmp(Editor[DELETEIMG].dat);
	abort_NULL(Delete, "BUTD&1");
	
	// Checkbox class checkmark image
	BoxCheck = get_datafile_bmp(Editor[BOXCHECK].dat);
	abort_NULL(BoxCheck, "BOXCHK&1");
	
	// Menu checkmark image
	checkmark = get_datafile_bmp(Editor[CHECKMARK].dat);
	abort_NULL(checkmark, "CHKMRK&1");
	
	// Window close button image
    WinClose = get_datafile_bmp(Editor[WINCLOSE].dat);
	abort_NULL(WinClose, "WINB&C");
	
	// Window close button pushed
    WinClosePush = get_datafile_bmp(Editor[WINCLOSEPUSH].dat);
	abort_NULL(WinClosePush, "WINBPC");
	
	// Window shade button image
    WinShade = get_datafile_bmp(Editor[WINSHADE].dat);
	abort_NULL(WinShade, "WINB&S");
	
	// Window shade button pushed
    WinShadePush = get_datafile_bmp(Editor[WINSHADEPUSH].dat);
	abort_NULL(WinShadePush, "WINBPS");
	
	// Window restore button image
    WinRestore = get_datafile_bmp(Editor[WINRESTORE].dat);
	abort_NULL(WinRestore, "WINB&R");
	
	// Window restore button pushed
    WinRestorePush = get_datafile_bmp(Editor[WINRESTOREPUSH].dat);
	abort_NULL(WinRestorePush, "WINBPR");
	
	// Slider image
    Slider = get_datafile_bmp(Editor[SLIDERIMG].dat);
	abort_NULL(Slider, "SLD&");
	
	// Slider bar end image
    SliderEnd = get_datafile_bmp(Editor[SCROLLEND].dat);
	abort_NULL(SliderEnd, "SLDE");
	
	// Slider bar end pushed
    SliderPush = get_datafile_bmp(Editor[SCROLLENDPUSH].dat);
	abort_NULL(SliderPush, "SLDP");
	
	// Mulitpurpose arrow sprite
    Arrow = get_datafile_bmp(Editor[ARROW].dat);
	abort_NULL(Arrow, "ARR&1");
	
	// Scrollbox arrow images
    ScrollArrow = get_datafile_bmp(Editor[SCROLLARROW].dat);
	abort_NULL(ScrollArrow, "SCR&A");
	
	// Scrollbox arrows pushed
    ScrollArrowPush = get_datafile_bmp(Editor[SCROLLARROWPUSH].dat);
	abort_NULL(ScrollArrowPush, "SCRPA");
	
	// Scrollbox dropdown image
    ScrollDown = get_datafile_bmp(Editor[DOWNARROW].dat);
	abort_NULL(ScrollDown, "SCRDA");
	
	// Listbox scroll up image
    ListUp = get_datafile_bmp(Editor[LISTUP].dat);
	abort_NULL(ListUp, "LST&U");
	
	// Listbox scroll up image pushed
    ListUpPush = get_datafile_bmp(Editor[LISTUPPUSH].dat);
	abort_NULL(ListUpPush, "LSTPU");
	
	// Listbox scroll down image
    ListDn = get_datafile_bmp(Editor[LISTDN].dat);
	abort_NULL(ListDn, "LST&D");
	
	// Listbox scroll down image pushed
    ListDnPush = get_datafile_bmp(Editor[LISTDNPUSH].dat);
	abort_NULL(ListDnPush, "LSTPD");
	
    // Viewport up scroll image
    ViewU = get_datafile_bmp(Editor[VIEWU].dat);
	abort_NULL(ViewU, "VW&U");
	
    // Viewport up scroll push image
    ViewUP = get_datafile_bmp(Editor[VIEWUP].dat);
	abort_NULL(ViewUP, "VWPU");
	
    // Viewport down scroll image
    ViewD = get_datafile_bmp(Editor[VIEWD].dat);
	abort_NULL(ViewD, "VW&D");
	
    // Viewport down scroll push image
    ViewDP = get_datafile_bmp(Editor[VIEWDP].dat);
	abort_NULL(ViewDP, "VWPD");
	
    // Viewport right scroll image
    ViewR = get_datafile_bmp(Editor[VIEWR].dat);
	abort_NULL(ViewR, "VW&R");
	
    // Viewport right scroll push image
    ViewRP = get_datafile_bmp(Editor[VIEWRP].dat);
	abort_NULL(ViewRP, "VWPR");
	
    // Viewport left scroll image
    ViewL = get_datafile_bmp(Editor[VIEWL].dat);
	abort_NULL(ViewL, "VW&L");
	
    // Viewport left scroll push image
    ViewLP = get_datafile_bmp(Editor[VIEWLP].dat);
	abort_NULL(ViewLP, "VWPL");
	
    // Map normal room image
    MapBox = get_datafile_bmp(Editor[BOX].dat);
	abort_NULL(MapBox, "MP&B");
	
	// Map item room image
    MapItem = get_datafile_bmp(Editor[ITEM].dat);
	abort_NULL(MapItem, "MP&I");
	
	// Map corner image
    MapSlice1 = get_datafile_bmp(Editor[SLICE].dat);
	abort_NULL(MapSlice1, "MPS1");
	
	// Map corner image
    MapSlice2 = get_datafile_bmp(Editor[SLICE2].dat);
	abort_NULL(MapSlice2, "MPS2");
	
	// Map corner image
    MapSlice3 = get_datafile_bmp(Editor[SLICE3].dat);
	abort_NULL(MapSlice3, "MPS3");
	
	// Map corner image
    MapSlice4 = get_datafile_bmp(Editor[SLICE4].dat);
	abort_NULL(MapSlice4, "MPS4");
	
	// Map elevator room image
    MapElevator = get_datafile_bmp(Editor[ELEVATOR].dat);
	abort_NULL(MapElevator, "MP&E");
	
	// Map diagonal stretch image
    MapDStretch = get_datafile_bmp(Editor[STRETCH].dat);
	abort_NULL(MapDStretch, "MPDS");
	
	// Map box stretch image
    MapBStretch = get_datafile_bmp(Editor[BOXSTRETCH].dat);
	abort_NULL(MapBStretch, "MPBS");
	
	// Room selection tool image
	ToolSelect = get_datafile_bmp(Editor[TOOLSELECT].dat);
	abort_NULL(ToolSelect, "TL&SLT");
	
	// Room eyedropper image
	ToolEyedrop = get_datafile_bmp(Editor[TOOLEYEDROP].dat);
	abort_NULL(ToolEyedrop, "TL&EYE");
	
	// Breakable image array
	BreakImages = NULL;
    BreakImages = (BITMAP **)qualloc(BreakImages, sizeof(BITMAP*) * 8);
	abort_NULL(BreakImages, "BRKI&00");
	
	// Crumble breakable image
	BreakImages[0] = get_datafile_bmp(Editor[BREAKCRUMB].dat);
	abort_NULL(BreakImages[0], "BRKI&00");
	
	// Shootable breakable image
	BreakImages[1] = get_datafile_bmp(Editor[BREAKSHOOT].dat);
	abort_NULL(BreakImages[1], "BRKI&01");
	
	// Missile block breakable image
	BreakImages[2] = get_datafile_bmp(Editor[BREAKNMISS].dat);
	abort_NULL(BreakImages[2], "BRKI&02");
	
	// Super Missile block breakable image
	BreakImages[3] = get_datafile_bmp(Editor[BREAKSMISS].dat);
	abort_NULL(BreakImages[3], "BRKI&03");
	
	// Bombable breakable image
	BreakImages[4] = get_datafile_bmp(Editor[BREAKRBOMB].dat);
	abort_NULL(BreakImages[4], "BRKI&04");
	
	// Power bomb block breakable image
	BreakImages[5] = get_datafile_bmp(Editor[BREAKPBOMB].dat);
	abort_NULL(BreakImages[5], "BRKI&05");
	
	// Screw attack block breakable image
	BreakImages[6] = get_datafile_bmp(Editor[BREAKSCREW].dat);
	abort_NULL(BreakImages[6], "BRKI&06");
	
	// Speed booster block breakable image
	BreakImages[7] = get_datafile_bmp(Editor[BREAKSPEED].dat);
	abort_NULL(BreakImages[7], "BRKI&07");
	
	unload_datafile(Editor);
    if(debug) logputs("Complete\n");
    
    char font_string[355];
    strcpy( font_string, install_path );
    strcat( font_string, "Data\\EditFonts.dat" );

    Fonts = load_datafile( font_string );
	abort_NULL(Fonts, "DTFL&FT&0");
	
    if(debug) logputs("\t\"Fonts.dat\" opened, loading fonts...");
    
    // Mouse location font
	TinyFont = (FONT *)Fonts[0].dat;
	abort_NULL(TinyFont, "FNT&TN0");
	
    if(debug) logputs("Complete\n");
}
